/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package shared;

import java.io.*;

/** 
 * The <code>SPOTMessage</code> class packages all SPOT related messages.
 * A <code>SPOTMessage</code> is serializable, so it is best used with a 
 * <code>ObjectInputStream</code> / <code>ObjectOutputStream</code> 
 * combination.
 *
 * @author Jason Howes
 * @version 1.0
 */
public class SPOTMessage implements Serializable
{
	/**
	 * Invalid message for debugging purposes.
	 */
	public final static byte INVALID_MESSAGE					= (byte)-1;
	
	/**
	 * Client message indicating the start of a session.
	 * <p>
	 * mObject is null.
	 */
	public final static byte START_SESSION						= (byte)0;
	
	/**
	 * Client or Server message indicating the end of a session.
	 * <p>
	 * mObject is null.
	 */
	public final static byte END_SESSION						= (byte)1;
	
	/**
	 * Standard server ACK.
	 * <p>
	 * mObject is specific to operation.
	 */
	public final static byte ACK								= (byte)2; 

	/**
	 * Standard server NACK.
	 * <p>
	 * mObject is specific to operation.
	 */
	public final static byte NACK								= (byte)3;	
	
	/**
	 * Client request for a presentation's topics.
	 * <p>
	 * mObject is a PresentationInfo object that describes the presentation.
	 */
	public final static byte REQUEST_PRESENTATION_TOPICS		= (byte)4;
	
	/**
	 * Server response to a REQUEST_PRESENTATION_TOPICS.
	 * <p>
	 * mObject is a Vector containing the presentation topics.
	 */
	public final static byte PRESENTATION_TOPICS				= (byte)5;
	
	/**
	 * Client request for the number of presentation slides.
	 * <p>
	 * mObject is a PresentationInfo object that describes the presentation.
	 */
	public final static byte REQUEST_NUM_PRESENTATION_SLIDES	= (byte)6;
	
	/**
	 * Server response to a REQUEST_NUM_PRESENTATION_SLIDES.
	 * <p>
	 * mObject is an Integer containing the number of presentation slides.
	 */
	public final static byte NUM_PRESENTATION_SLIDES			= (byte)7;

	/**
	 * Client request for the presentation file to be sent.
	 * <p>
	 * mObject is a PresentationInfo object that describes the presentation.
	 */
	public final static byte REQUEST_PRESENTATION 				= (byte)8;

	/**
	 * Server response to a REQUEST_PRESENTATION.
	 */
	public final static byte BEGIN_PRESENTATION_TRANSFER		= (byte)9;

	/**
	 * Holds a chunk of a file.
	 * <p>
	 * mObject is a byte array containing the byte-chunk of the file.
	 */
	public final static byte FILE_CHUNK							= (byte)10;

	/**
	 * Message from server to indicate end of a presentation file transfer.
	 */
	public final static byte END_PRESENTATION_TRANSFER			= (byte)11;
	
	/**
	 * Message from client as a request to open the presentation.
	 * <p>
	 * mObject is a PresentationInfo object that describes the presentation.
	 */
	public final static byte OPEN_PRESENTATION	   				= (byte)20;
	
	/**
	 * Message from client as a request to start the ITX connection.
	 */
	public final static byte CONNECT							= (byte)12;

	/**
	 * Message from client as a request to begin the presentation.
	 * <p>
	 * mObject is a PresentationInfo object that describes the presentation.
	 */
	public final static byte START_PRESENTATION	   				= (byte)13;

	/**
	 * Message from client as a request to stop the presentation.
	 * <p>
	 * mObject is null
	 */
	public final static byte STOP_PRESENTATION	   				= (byte)14; 

    /**
	 * Message from the client as a request to pause the presentation.
	 * <p>
	 * mObject is null
	 */
	public final static byte PAUSE_PRESENTATION	   				= (byte)15; 

    /**
	 * Message from the client as a request to resume the presentation (un-pause).
	 * <p>
	 * mObject is null
	 */
	public final static byte RESUME_PRESENTATION	   			= (byte)16;
	
	/**
	 * Message from the client as a request to change the presentation slide number.
	 * <p>
	 * mObject is an Integer representing the new presentation slide number.
	 */
	public final static byte REQUEST_PRESENTATION_SLIDE_CHANGE	= (byte)17;
	
	/**
	 * Message from the client as a request to change the presentation slide number
	 * to the presentation slide that corresponds to a given topic.
	 * <p>
	 * mObject is an String representing the topic.
	 */
	public final static byte REQUEST_PRESENTATION_TOPIC_SLIDE	= (byte)18;	

	/**
	 * Message from server to client to inform of a slide change.
	 * <p>
	 * mObject is an Integer representing the new presentation slide number.
	 */
	public final static byte PRESENTATION_SLIDE_CHANGE			= (byte)19;

	/**	
	 * The type of the message.
	 */
	public byte mType;

	/** 
	 * The Object contained in the message.
	 */
	public Object mObject;

	/**
	 * Class constructor.
	 *
	 * @param type the message type (SPOTMessage.xxx)
	 * @param object the (serializable) object to be contained in this message
	 */
	public SPOTMessage(byte type, Object object)
	{
		mType    = type;
		mObject  = object;
	}

	/**
	 * Class constructor.
	 *
	 * @param type the message type (SPOTMessage.xxx)
	 */
	public SPOTMessage(byte type)
	{
		mType    = type;
		mObject  = null;
	}
}